# Install Task Parenting -- requires version 0.5 or greater
# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050329 - first draft of program based on Install Float Tracking
# 050519 - rename ParentTaskID to TaskID in Task table; changes some of the other names and aliases, too.
# 060204 - copied resource name columns to Install Assignment Hours script (they should be removed from here in a future release)

# This script must be run against each file to include the new report options.
# It might be a good idea to create another 'Task' alias: 'ParentTask' 
# -- No, by using the column name 'TaskID' instead of 'ParentTaskID' there is no need for the alias.

def DoAdd():
    # if not Data.Database.has_key('ParentTask'):
    #     Data.Database['ParentTask'] = Data.Database['Task']
    rt = { 'Name': 'Task' }  
    ct = [
    { 'Name': 'TaskID', 'Label': 'Parent\nTask ID', 'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 56  },
    { 'Name': 'Prerequisites', 'Path': 'ID/Dependency/TaskID/PrerequisiteID//', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'Successors', 'Path': 'ID/Dependency/PrerequisiteID/TaskID//', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 70  },
    { 'Name': 'ChildTasks', 'Label': 'Child\nTasks', 'Path': 'ID/Task/TaskID/ID//', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 60  },

    # ------ these columns are now in the Install Assignment Hours script (remove from here in future release) -----------
    { 'Name': 'ResourceNames', 'Label': 'Resource\nNames', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/Name', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'ResourcesShortNames', 'Label': 'Resource\nShort Names', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/ShortName', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    # ------

            # '': 
            # '': 
            # '': 
        ]
    Data.AddReportType(rt, ct)
    Data.SetUndo("Install Task Parenting")

DoAdd()
